IF EXISTS (SELECT* FROM SYS.VIEWS WHERE
						OBJECT_ID = OBJECT_ID(N'[dbo].[V_NETPOINTS_ENVIO_PENDENTE]'))
	BEGIN
		DROP VIEW [dbo].[V_NETPOINTS_ENVIO_PENDENTE];
	END
GO
--SELECT TOP  0 * FROM [dbo].[V_NETPOINTS_ENVIO_PENDENTE]
CREATE VIEW [dbo].[V_NETPOINTS_ENVIO_PENDENTE]
AS
	SELECT
		VD.CD_EMP
		,VD.CD_FILIAL
		,VD.CD_VD
		,VD.CD_CX
		,
		--(select convert(datetime, convert(varchar,vd.DT_VD,112) + ' ' + convert(varchar,VD.HR_VD,108))) as DT_VD,
		vd.DT_VD
		,VD.HR_VD
		,VD.NR_ECF
		,VD.NR_ORC
		,VD.VLR_LIQ_VD
		,
		--12345678912 as CGC_CPF,
		CLI.CGC_CPF
		,EMP.CGC_EMP
		,FILIAL.CGC                   AS CGC_FILIAL
		,VD.VLR_DINH
		,VD.VLR_CHQS
		,VD.VLR_CARTAO
		,VD.VLR_TICKETS
		,VD.VLR_DUP
		,VD.VLR_CONV
		,VD.VLR_NCC
		,VD.VLR_CONV_PBM
		,SUM(PONTOS.QTDE_PONTO_FIDEL) AS QT_PONTOS
	FROM
		PDV_VD VD
		INNER JOIN RC_CLI CLI ON
			VD.CD_EMP = CLI.CD_EMP AND
			VD.CD_CLI = CLI.CD_CLI
		INNER JOIN PRC_EMP EMP ON
			VD.CD_EMP = EMP.CD_EMP
		INNER JOIN PRC_FILIAL FILIAL ON
			VD.CD_EMP = FILIAL.CD_EMP AND
			VD.CD_FILIAL = FILIAL.CD_FILIAL
		INNER JOIN PDV_VD_IT IT ON
			VD.CD_EMP = IT.CD_EMP AND
			VD.CD_FILIAL = IT.CD_FILIAL AND
			VD.CD_VD = IT.CD_VD
		INNER JOIN PDV_VD_IT_FIDELI_CARTAO PONTOS ON
			IT.CD_EMP = PONTOS.CD_EMP AND
			IT.CD_FILIAL = PONTOS.CD_FILIAL AND
			IT.CD_VD = PONTOS.CD_VD AND
			IT.CD_IT = PONTOS.CD_IT
	WHERE
		VD.CD_EMP          = 1 AND
		VD.ST_VD           = 0 AND
		PONTOS.ENVIO_FIDEL = 0
	GROUP  BY
		VD.CD_EMP
		,VD.CD_FILIAL
		,VD.CD_VD
		,VD.CD_CX
		,VD.DT_VD
		,VD.HR_VD
		,VD.NR_ECF
		,VD.NR_ORC
		,VD.VLR_LIQ_VD
		,CLI.CGC_CPF
		,EMP.CGC_EMP
		,FILIAL.CGC
		,VD.VLR_DINH
		,VD.VLR_CHQS
		,VD.VLR_CARTAO
		,VD.VLR_TICKETS
		,VD.VLR_DUP
		,VD.VLR_CONV
		,VD.VLR_NCC
		,VD.VLR_CONV_PBM 
